

function PlaylistDocument(object) {
	this.unique_id = object.unique_id;
	this.duration_string = "";
	this.duration_timecode = "";
	this.total_items = 0;
	this.items = [];
	this.cue = false;
	this.loop = false;
	this.shuffle = false;
	this.chain = false;
	this.is_folder_based = false;
	this.path = object.path;
	this.player_description = "";

	this.actionFilter;
	this.isPlaying = false;
	this.element = undefined;

	this.updateFrom = function(object) {
		if (object) {
			if (object.name != undefined)
				this.name = object.name;
			if (object.duration != undefined)
				this.duration = object.duration;
			if (object.duration_string != undefined)
				this.duration_string = object.duration_string;
			if (object.duration_timecode != undefined)
				this.duration_timecode = object.duration_timecode;
			if (object.total_items != undefined)
				this.total_items = (object.total_items) ? object.total_items : 0;
			if (object.cue != undefined)
				this.cue = object.cue;
			if (object.loop != undefined)
				this.loop = object.loop;
			if (object.shuffle != undefined)
				this.shuffle = object.shuffle;
			if (object.chain != undefined)
				this.chain = object.chain;
			if (object.is_folder_based != undefined)
				this.is_folder_based = object.is_folder_based;
			if (object.path != undefined)
				this.path = object.path;
			if (object.player_description != undefined)
				this.player_description = object.player_description;

			if (object.items != undefined) {
				//empty item list
				this.items = [];

				for (let i = 0; i < object.items.length; i++) {
					const item = new PlaylistItem(object.items[i], this);
					this.items.push(item);
				}
			}
		}
	}

	if (object) {
		this.updateFrom(object);
	}

	this.playlistItemWithUniqueID = function(uniqueID) {
		for (let i = 0; i < this.items.length; i++) {
			const item = this.items[i];
			if (item.unique_id === uniqueID) {
				return item;
			}
		}

		return undefined;
	}

	this.getResolvedDisplayName = function() {
		if (this.path !== undefined && this.path !== "") {
			let result = this.path.replace(/^.*[\\\/]/, '');
			if (result.endsWith(".xpls")) {
				//remove ".xpls" extension
				result = result.substring(0, result.length - 5);
			}
			return result;
		}

		return this.name;
	}
}
